use "C:\Users\Natasha Sarin\Dropbox\Harvard\Research\Banks\International Data March 2016\merged_vol_implied_vol__marketvols_20160314.dta", clear

capture drop crisis
generate crisis = . 
replace crisis = 0 if year >= 2002 & year <= 2007 
replace crisis = 1 if year >= 2010 & year <= 2015

gen implied_minus_market = implied_vol - market_implied_vol 
gen implied_div_market = implied_vol/market_implied_vol 
gen vol_minus_market = vol-market_vol
gen vol_div_market = vol/market_vol

replace stock_price = . if stock_price == 0 
replace beta = . if beta == 0 
replace book_value_ps = . if book_value_ps == 0 
replace implied_vol = . if implied_vol == 0 
replace cds_spread = . if cds_spread == 0 
replace ptb = . if ptb == 0 
replace vol = . if vol == 0 
replace market_vol = . if market_vol == 0 
replace market_implied_vol = . if market_implied_vol == 0 

keep if year >= 2002 
keep if year <= 2015 



**** compute whole sample yearly averages and median 
by year, sort: egen beta_mean_year = mean(beta)
by year, sort: egen beta_median_year = median(beta)
by year, sort: egen vol_mean_year = mean(vol)
by year, sort: egen vol_median_year = median(vol)
by year, sort: egen imp_div_market_mean_year = mean(implied_div_market)
by year, sort: egen imp_div_market_median_year = median(implied_div_market)
by year, sort: egen vol_div_market_mean_year = mean(vol_div_market)
by year, sort: egen vol_div_market_median_year = median(vol_div_market)
by year, sort: egen impvol_mean_year = mean(implied_vol)
by year, sort: egen impvol_median_year = median(implied_vol)
by year, sort: egen cds_mean_year = mean(cds_spread)
by year, sort: egen cds_median_year = median(cds_spread)
by year, sort: egen ptb_mean_year = mean(ptb)
by year, sort: egen ptb_median_year = median(ptb)

capture drop test_year

by year, sort: gen test_year = _n

br year vol_mean_year vol_median_year vol_div_market_mean_year vol_div_market_median_year impvol_mean_year impvol_median_year imp_div_market_mean_year imp_div_market_median_year beta_mean_year beta_median_year cds_mean_year cds_median_year if test_year == 1 & year == 2015 
keep if test_year == 1
br


cd "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Figures_EPS"


summarize beta_mean_year 

twoway scatteri 0 2007.8 0 2009.8 `=r(max)' 2009.8 `=r(max)' 2007.8 0 2007.8, recast(area) color(gray*0.3) ///
|| scatter beta_mean_year year, legend(off) xlab(2002(2)2015) ytitle("Beta")
graph export beta_intl.eps, as(eps) replace
graph export beta_intl.png, replace



summarize vol_mean_year 

twoway scatteri 0 2007.8 0 2009.8 `=r(max)' 2009.8 `=r(max)' 2007.8 0 2007.8, recast(area) color(gray*0.3) ///
|| scatter vol_mean_year year, legend(off) xlab(2002(2)2015) ytitle("Volatility") 

graph export vol_intl.eps, as(eps) replace
graph export vol_intl.png, replace


summarize vol_div_market_mean_year 

twoway scatteri 0 2007.8 0 2009.8 `=r(max)' 2009.8 `=r(max)' 2007.8 0 2007.8, recast(area) color(gray*0.3) ///
|| scatter vol_div_market_mean_year year, legend(off) xlab(2004(2)2015) ytitle("Volatility/Market Implied Volatility")
graph export mean_vol_div_market_annual.eps, as(eps) replace
graph export mean_vol_div_market_annual.png, replace


summarize imp_div_market_mean_year 

twoway scatteri 0 2007.8 0 2009.8 `=r(max)' 2009.8 `=r(max)' 2007.8 0 2007.8, recast(area) color(gray*0.3) ///
|| scatter imp_div_market_mean_year year if year>= 2004, legend(off) xlab(2004(2)2015) ytitle("Implied Volatility/Market Implied Volatility")
graph export imp_div_annual_intl.eps, as(eps) replace
graph export imp_div_annual_intl.png, replace


summarize cds_mean_year 
twoway scatteri 0 2007.8 0 2009.8 `=r(max)' 2009.8 `=r(max)' 2007.8 0 2007.8, recast(area) color(gray*0.3) ///
|| scatter cds_mean_year year if year>= 2004, legend(off) xlab(2004(2)2015) ytitle("CDS Spread") 

graph export cds_intl.eps, as(eps) replace
graph export cds_intl.png, replace


summarize impvol_mean_year

twoway scatteri 0 2007.8 0 2009.8 `=r(max)' 2009.8 `=r(max)' 2007.8 0 2007.8, recast(area) color(gray*0.3) ///
|| scatter impvol_mean_year year if year>= 2004, legend(off) xlab(2004(2)2015) ytitle("Implied Volatility")

graph export implied_intl.eps, as(eps) replace
graph export implied_intl.png, replace


